## DeepSeek 提示词基本法则
> 官方提供了一些 prompt ：https://api-docs.deepseek.com/zh-cn/prompt-library/



DeepSeek作为前沿AI工具，其潜力远超“简单问答”——关键在于如何用精准的提示词（Prompt）激活它的“隐藏技能”。玩了一阵子DeepSeek，小编总结了各行业场景化模板到底层设计逻辑，“提问的艺术”十分有必要，不同的提问姿势，给出的答案往往会千差万别 ！！

------

## 一、提示词设计的黄金法则

**1. 具体性为王**
❌ 模糊提问：“写一篇市场报告”
✅ 精准指令：“作为消费品行业分析师，写一份2024年中国智能家居市场的竞争格局报告，需包含头部品牌份额、技术趋势（如AIoT）、用户画像（25-40岁新中产），数据引用头豹研究院和Statista，用Markdown表格对比关键指标。”



**2. 结构化思维**
**“角色-任务-约束”框架**：

**角色**：资深Python工程师
**任务**：优化图像分类模型的推理速度
**约束**：现有模型为ResNet50，硬件为单卡RTX 3090，要求推理时间降低30%且精度损失≤2%
**附加指令**：提供可复现的代码示例，优先推荐剪枝、量化之外的创新方案

**3. 动态修正机制**

- **第一步**：生成初稿
  “用Python实现一个股票价格预测模型，基于LSTM，输出训练代码和可视化结果”
- **第二步**：定向优化
  “在初稿基础上增加以下功能：① 引入Transformer模块替代部分LSTM层；② 添加贝叶斯超参数优化逻辑；③ 用Plotly生成交互式回测图表”

------

## 二、行业级提示词模板库

**1. 学术科研**

**场景**：文献综述突破
**模板**：
“你是一名计算生物学方向的博士后，需要总结近3年《Nature》上关于CRISPR-Cas9脱靶效应检测技术的突破性研究。请按以下框架输出：

1. 方法论创新（分基因编辑工具开发、检测算法两类）
2. 关键数据集与实验设计对比（用表格呈现）
3. 未解决的科学问题（至少列出3点）
   *要求引用2021年后论文，标注DOI编号*”

**解析**：角色绑定+时间限定+结构化输出+数据溯源，避免泛泛而谈。

------

**2. 编程开发**

**场景**：代码调试与优化
**模板**：
“现有Django项目使用PostgreSQL时出现‘连接池耗尽’错误（错误码：53300），当前配置：

- `max_connections=100`
- 并发请求峰值约200/秒
- 使用gunicorn部署（4 workers）
  请：
  ① 分析可能原因（按数据库、ORM、服务器配置三类）
  ② 给出5条优化方案，按实施难度排序
  ③ 提供修改`settings.py`和`gunicorn.conf`的代码片段”

**解析**：环境参数+错误细节+多维度解决方案+代码级输出，精准定位问题。

------

**3. 创意内容**

**场景**：短视频剧本创作
**模板**：
“作为科普类短视频编导，需要创作一期‘量子纠缠’主题的脚本，目标观众为18-25岁大学生。要求：

- 时长3分钟内，包含3个反转点
- 用‘快递员送包裹’类比量子通信过程
- 结尾抛出争议性问题引导评论区互动
- 参考《天才简史》的幽默叙事风格
  请输出分镜脚本（景别/台词/时长），并标注重点特效需求”

**解析**：类比思维+互动设计+风格锚定，让创意兼具专业性与传播力。

------

**4. 商业分析**

**场景**：竞品战略拆解
**模板**：
“假设你是特斯拉中国区战略顾问，请用波特五力模型分析2024年蔚来汽车的竞争态势，重点关注：

- 供应商议价能力（电池、芯片供应链）
- 新进入者威胁（小米汽车、华为智选）
- 替代品压力（氢能源、共享出行）
  输出要求：
  ① 每个维度列出3个核心事实（带数据来源）
  ② 用SWOT矩阵总结战略建议
  ③ 生成可视化图表代码（Python Matplotlib）”

**解析**：理论模型+数据驱动+可视化支持，打造决策级报告。

------

## 三、高阶技巧：让AI“深度思考”

**1. 分步思考链（Chain-of-Thought）**

**示例**：
“请逐步推理：若2025年中国新能源汽车渗透率达到50%，对以下行业的影响路径是什么？
① 石油化工 → ② 电网基础设施 → ③ 二手车市场
要求每一步包含：

- 直接影响（1年内）
- 二阶效应（3-5年）
- 数据测算公式（如充电桩需求=车辆数×日均充电量/桩利用率）”

**价值**：强迫AI展示推理过程，便于验证逻辑漏洞。

------

**2. 多模态生成控制**

**示例**：
“生成一份‘智慧城市’技术架构图：

1. 用Mermaid语法绘制分层架构（感知层/网络层/平台层/应用层）
2. 为每层添加3个典型技术案例（如感知层：5G摄像头、环境传感器）
3. 用DALL·E提示词描述配套可视化风格（赛博朋克+极简线条）”

**价值**：统一控制文本、代码、图像的协同输出。

------

## 四、避坑指南

**1. 避免“幻觉”**

- **事实核查指令**：
  “关于‘石墨烯电池量产进展’的回答，请仅引用宁德时代、LG化学2023年后官方公告或权威期刊论文（如《Joule》）”
- **不确定性标注**：
  “若某观点存在学术争议，请标注‘待验证’并列出正反双方论据”

**2. 效率跃迁**

- **批量处理模板**：
  “以下是20条用户评论，请按情感倾向（积极/中性/消极）分类，并提取每条的关键需求点，输出CSV格式：
  [粘贴评论文本]”
- **自动化接口**：
  “将上述数据分析流程封装为Python函数，输入为Pandas DataFrame，输出为PDF报告，用FastAPI生成可调用的HTTP接口”

------

掌握提示词设计，本质上是在**用自然语言编写AI的“驱动程序”**。建议建立个人“Prompt库”，持续迭代三类资产：

1. **领域模板**：高频场景的标准化提问框架
2. **修正记录**：每次对话中的优化路径（如“第3版比第1版新增了数据验证环节”）
3. **风险清单**：特定领域的AI常见错误及应对策略

## 避坑指南

🚫 **避免开放式提问**："分析市场趋势" → 改为"用3个真实案例说明2024年奶茶店倒闭潮原因"。

🚫 **警惕幻觉数据**：要求"所有数据标注来源，不确定的内容用'据行业推测'表述"。

🚫 **长文本分段处理**：超过3000字时按"背景-论点-论据-结论"分块生成。



> 来源：https://post.smzdm.com/p/a34e74z5/
